Rem NINA.vbs
Rem Wicej informacji o ksztatach NINA znale mona na stronie:
Rem http://www.washington.edu/bibsys/mattf/nina/index.html
Set myInDesign = CreateObject("InDesign.Application.CS2")
If myInDesign.Documents.Count <> 0 Then
If TypeName(myInDesign.ActiveWindow) = "LayoutWindow" Then
set myViewPreferences = myInDesign.ActiveDocument.ViewPreferences
myOldXUnits = myViewPreferences.HorizontalMeasurementUnits
myOldYUnits = myViewPreferences.VerticalMeasurementUnits
set myDocument = myInDesign.ActiveDocument
myDocument.ViewPreferences.HorizontalMeasurementUnits = _
idMeasurementUnits.idPoints
myDocument.ViewPreferences.VerticalMeasurementUnits = _
idMeasurementUnits.idPoints
myDisplayDialog myInDesign
myDocument.ViewPreferences.HorizontalMeasurementUnits = _
myOldXUnits
myDocument.ViewPreferences.VerticalMeasurementUnits = _
myOldYUnits
End If
End If
Function myDrawNina(myInDesign, myNumberOfLines, a_pulse, b_pulse, _
myLength, myClosedPath)
pi = 3.14159265358979
Set myDocument = myInDesign.ActiveDocument
Set myPage = myInDesign.ActiveWindow.ActivePage
ReDim myArray(myNumberOfLines)
Rem Wypeniamy tablic wsprzdnymi punktw
For myCounter = 0 To (myNumberOfLines)
cur_x = (Cos((-2 * pi * a_pulse * myCounter) / myNumberOfLines) _
+ Cos((-2 * pi * b_pulse * myCounter) / myNumberOfLines)) * _
myLength
cur_y = (Sin((-2 * pi * a_pulse * myCounter) / myNumberOfLines) _
+ Sin((-2 * pi * b_pulse * myCounter) / myNumberOfLines)) * _
myLength
myArray(myCounter) = Array(cur_x, cur_y)
Next
Set myGraphicLine = myPage.GraphicLines.Add
Rem Przesuwamy nieco lini graficzn 
myGraphicLine.Move , Array("1p", "1p")
Rem Tworzymy punkty na ciece w oparciu o tablic wygenerowan przez ptl.
myGraphicLine.Paths.Item(1).EntirePath = myArray
Rem Dodajemy opis ustawie
myGraphicLine.Label = "number_of_lines = " & CStr(myNumberOfLines) _
& ", a_pulse = " & CStr(a_pulse) & ", b_pulse = " & CStr(b_pulse)
If myClosedPath = True Then
myGraphicLine.Paths.Item(1).PathType = idPathType.idClosedPath
Else
myGraphicLine.Paths.Item(1).PathType = idPathType.idOpenPath
End If
End Function
Function myDisplayDialog(myInDesign)
Set myDialog = myInDesign.Dialogs.Add
myDialog.Name = "NINA"
With myDialog.DialogColumns.Add
With .BorderPanels.Add
With .DialogColumns.Add
With .StaticTexts.Add
.StaticLabel = "Number of iterations:"
End With
With .StaticTexts.Add
.StaticLabel = "a_pulse:"
End With
With .StaticTexts.Add
.StaticLabel = "b_pulse:"
End With
With .StaticTexts.Add
.StaticLabel = "Line length (in points):"
End With
End With
With .DialogColumns.Add
Set myNumberOfLinesField = .IntegerEditboxes.Add
myNumberOfLinesField.EditValue = 201
myNumberOfLinesField.MinWidth = 60
Set myAPulseField = .IntegerEditboxes.Add
myAPulseField.EditValue = 16
myAPulseField.MinWidth = 60
Set myBPulseField = .IntegerEditboxes.Add
myBPulseField.EditValue = 161
myBPulseField.MinWidth = 60
Set myLengthField = .MeasurementEditboxes.Add
myLengthField.EditValue = 72
myLengthField.MinWidth = 60
myLengthField.EditUnits = idMeasurementUnits.idPoints
End With
End With
With .BorderPanels.Add
With .RadiobuttonGroups.Add
Set myClosedPathButton = .RadiobuttonControls.Add
myClosedPathButton.StaticLabel = "Closed path"
myClosedPathButton.CheckedState = True
With .RadiobuttonControls.Add
.StaticLabel = "Open path"
End With
End With
End With
End With
myReturn = myDialog.Show
If myReturn = True Then
Rem Pobieramy wartoci z pl okna dialogowego.
myNumberOfLines = myNumberOfLinesField.EditValue
a_pulse = myAPulseField.EditValue
b_pulse = myBPulseField.EditValue
myLength = myLengthField.EditValue
myClosedPath = myClosedPathButton.CheckedState
myDialog.Destroy
myDrawNina myInDesign, myNumberOfLines, a_pulse, b_pulse, _
myLength, myClosedPath
Else
myDialog.Destroy
End If
End Function